/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabyDragon;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Dragon
extends EntityLivingDragon {
    private int soundcount = 0;
    Texture texturewhite = null;
    Entity targetentity = null;
    Entity hurtMe = null;
    float attackRange = 4.5f;
    int searchcounter = 0;
    float myspeed = 0.25f;
    private int fireballticker = 0;

    public Dragon(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 1.75f;
        this.width = 2.25f;
        this.uniquename = "OreSpawn:Dragon";
        this.moveSpeed = 0.2f;
        this.setMaxHealth(300.0f);
        this.setHealth(300.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(30.0f);
        this.movefrequency = 55;
        this.setExperience(199);
        this.sit_when_riding = true;
        this.takesFallDamage = false;
        this.isImmuneToFire = true;
        if (DangerZone.rand.nextInt(100) > 50) {
            this.setBID(1);
        } else {
            this.setBID(1);
            this.setBID(0);
        }
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 24.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.canFly = true;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Dragontexture.png");
            this.texturewhite = TextureMapper.getTexture((String)"orespawnres/skins/WhiteDragontexture.png");
        }
        if (this.getBID() != 0) {
            return this.texturewhite;
        }
        return this.texture;
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic == null && this.getOwnerName() != null && p.getPetName().equals(this.getOwnerName())) {
                if (this.isMountedBy((Entity)p)) {
                    this.unMount((Entity)p);
                } else {
                    this.Mount((Entity)p);
                    this.setSitting(false);
                    this.setStaying(false);
                }
                return false;
            }
            if (ic != null && ic.iid == Items.diamond.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                BabyDragon sc = (BabyDragon)this.world.createEntityByName("OreSpawn:BabyDragon", this.dimension, this.posx, this.posy, this.posz);
                if (sc != null) {
                    sc.init();
                    sc.setOwnerName(this.getOwnerName());
                    sc.setCanDespawn(false);
                    this.world.spawnEntityInWorld((Entity)sc);
                    this.deadflag = true;
                }
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
        }
        return super.rightClickedByPlayer(p, ic);
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.moosemeat.itemID;
    }

    public float getRiderYoffset() {
        if (this.isBaby()) {
            return 0.35f;
        }
        return 1.4f;
    }

    public float getRiderXZoffset() {
        if (this.isBaby()) {
            return 0.1375f;
        }
        return 0.55f;
    }

    private void doFlyingAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 6) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(4) == 1) {
            if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange * 2.0f + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                float dmg = this.getAttackDamage();
                int dt = 4;
                this.targetentity.doAttackFrom((Entity)this, dt, dmg);
            } else if (this.getRiderEntity() == null && this.world.rand.nextBoolean()) {
                double startz;
                double starty;
                double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
                ThrownFireball e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty = this.posy - 0.5, startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(Items.fireball.itemID);
                    e.thrower = this;
                    e.explosive_power = 2.0f;
                    float hdist = (float)Math.sqrt((this.targetentity.posx - startx) * (this.targetentity.posx - startx) + (this.targetentity.posz - startz) * (this.targetentity.posz - startz));
                    float tdirxz = (float)Math.atan2(this.targetentity.posx - startx, this.targetentity.posz - startz);
                    float tdiry = (float)Math.atan2(starty - (this.targetentity.posy + (double)(this.targetentity.getHeight() / 2.0f)), hdist);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 6.5f, 0.2f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            }
        }
    }

    private void doNormalAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(10) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (e instanceof Player) {
            return false;
        }
        if (e instanceof Girlfriend) {
            return false;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 1) {
            return null;
        }
        int which = this.world.rand.nextInt(6);
        if (which == 0) {
            return "OreSpawn:roar1";
        }
        if (which == 1) {
            return "OreSpawn:roar2";
        }
        if (which == 2) {
            return "OreSpawn:roar3";
        }
        if (which == 3) {
            return "OreSpawn:roar4";
        }
        if (which == 4) {
            return "OreSpawn:roar5";
        }
        return "OreSpawn:roar6";
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setFlying(true);
        this.setStaying(false);
        if (e != null && this.isSuitableTarget(e)) {
            this.hurtMe = e;
        }
        if (dt == 9) {
            return;
        }
        if (dt == 10) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    public void doEntityAction(float deltaT) {
        Entity rider = this.getRiderEntity();
        if (this.isFlying()) {
            ++this.soundcount;
            if (this.soundcount > 12) {
                this.soundcount = 0;
                int which = this.world.rand.nextInt(3);
                if (which == 0) {
                    this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                if (which == 1) {
                    this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                if (which == 2) {
                    this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
            }
        }
        if (rider == null) {
            if (!this.isFlying()) {
                if (!this.getStaying()) {
                    this.doNormalAttack();
                    if (this.getOwnerName() != null) {
                        double dist = 0.0;
                        Entity e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
                        if (e != null) {
                            dist = this.getDistanceFromEntity(e);
                        }
                        if (dist > (double)(this.maxdisttoowner + 8.0f)) {
                            this.setFlying(true);
                        }
                    }
                    if (this.world.rand.nextInt(500) == 1) {
                        this.setFlying(true);
                    }
                }
                super.doEntityAction(deltaT);
                return;
            }
            this.doFlyingAttack();
            this.doSoloFlying(deltaT);
            this.doLookAction();
            if (this.world.rand.nextInt(500) == 1) {
                this.setFlying(false);
            }
            if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
            return;
        }
        float faster = deltaT * 5.0f;
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if (ddiff > 0.2f) {
            ddiff = 0.2f;
        }
        if (ddiff < -0.2f) {
            ddiff = -0.2f;
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        if (this.getOnGround()) {
            this.setFlying(false);
        } else {
            this.setFlying(true);
            Utils.SpawnDustAlongPath((EntityLiving)this);
        }
        this.doFlyingAttack();
        ++this.fireballticker;
        if (this.fireballticker > 5) {
            this.fireballticker = 6;
        }
        if (rider.getForward()) {
            this.motionx = (float)((double)this.motionx + (double)this.moveSpeed * Math.sin(tdir) * (double)faster);
            this.motionz = (float)((double)this.motionz + (double)this.moveSpeed * Math.cos(tdir) * (double)faster);
        }
        if (rider.getBackward()) {
            this.motionx = (float)((double)this.motionx - (double)this.moveSpeed * Math.sin(tdir));
            this.motionz = (float)((double)this.motionz - (double)this.moveSpeed * Math.cos(tdir));
        }
        if (rider.getLeft()) {
            this.motionx = (float)((double)this.motionx + (double)this.moveSpeed * Math.sin((double)tdir + 1.5707963267948966));
            this.motionz = (float)((double)this.motionz + (double)this.moveSpeed * Math.cos((double)tdir + 1.5707963267948966));
            if (this.fireballticker > 5) {
                this.fireballticker = 0;
                this.doriderfireball();
            }
        }
        if (rider.getRight()) {
            this.motionx = (float)((double)this.motionx - (double)this.moveSpeed * Math.sin((double)tdir + 1.5707963267948966));
            this.motionz = (float)((double)this.motionz - (double)this.moveSpeed * Math.cos((double)tdir + 1.5707963267948966));
            if (this.fireballticker > 5) {
                this.fireballticker = 0;
                this.doriderfireball();
            }
        }
        if (rider.getUp()) {
            this.motiony += 0.28f * deltaT;
        }
        if (rider.getDown()) {
            this.motiony += 0.19f * deltaT;
        }
    }

    public void doSoloFlying(float deltaT) {
        int bid;
        Entity e;
        int keep_trying = 35;
        double px = this.posx;
        double py = this.posy;
        double pz = this.posz;
        double dist = 0.0;
        int dxz = 25;
        float speedadjust = 1.0f;
        if (this.getOwnerName() != null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null) {
            px = e.posx;
            py = e.posy + (double)(e.getHeight() / 2.0f);
            pz = e.posz;
            dxz = 20;
            dist = this.getDistanceFromEntity(e);
            if (dist > (double)this.maxdisttoowner) {
                speedadjust = 1.75f;
            }
            if (dist > (double)(this.maxdisttoowner * 1.5f)) {
                speedadjust = 2.75f;
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                this.target.setTarget(px + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)), py + (double)(this.world.rand.nextInt(8) - 2), pz + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)));
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                --keep_trying;
            }
            this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 8.0);
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath((EntityLiving)this);
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)Blocks.flower_red.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            Utils.doDropRand((World)this.world, (int)Blocks.flower_yellow.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophydragon.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    private void doriderfireball() {
        Entity rider = this.getRiderEntity();
        ThrownFireball e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() + 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch))), this.posy, this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() + 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch))));
        if (e != null) {
            e.init();
            e.setBID(0);
            e.setIID(Items.fireball.itemID);
            e.thrower = this;
            e.explosive_power = 1.0f;
            e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(rider.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(rider.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(rider.rotation_pitch_head))), (float)Math.cos(Math.toRadians(rider.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(rider.rotation_pitch_head)), 7.0f, 0.05f);
            this.world.spawnEntityInWorld((Entity)e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.6f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }
}

